# API Reference

## Authentication

All endpoints require an `X-API-Key` header containing one of the values configured in the `API_KEYS` environment variable. Requests exceeding the configured rate limits return `429 Too Many Requests`.

## Endpoints

### `GET /`

Health check endpoint.

**Response**

```json
{
  "status": "healthy",
  "message": "API is running",
  "timestamp": "2024-01-01T12:00:00"
}
```

### `POST /check`

Reconcile transactions against uploaded files or remote datasets.

**Headers**

- `Content-Type: application/json` or `multipart/form-data`
- `X-API-Key: <your-api-key>`

**Rate Limit**

- Default: `10 per minute` (configurable via `CHECK_RATE_LIMIT`)

**Request Body (JSON)**

```json
{
  "records": [
    {
      "record_id": "123",
      "price": "250000",
      "source": "sheet1"
    }
  ],
  "file_api": {
    "sheet1": "https://example.com/data/sheet1.xlsx"
  },
  "save_api_endpoint": "https://example.com/api/save"
}
```

**Multipart Form Fields**

- `data`: JSON payload identical to the body above.
- `sheet1`, `sheet2`, `input_pdf`: Optional file uploads (`.xlsx`, `.xls`, `.pdf`, `.csv`).

**Responses**

- `200 OK` with reconciliation results and background save task metadata.
- `400 Bad Request` for validation errors or unsupported file types.
- `401 Unauthorized` when the API key is missing or invalid.
- `429 Too Many Requests` when rate limits are exceeded.
- `502 Bad Gateway` when remote file downloads fail validation or retrieval.

See the `save_results` array in the response to track background export tasks.
